/*++

   INTEL CONFIDENTIAL
   Copyright 2012-2014 Intel Corporation All Rights Reserved.
   The source code contained or described herein and all documents related
   to the source code ("Material") are owned by Intel Corporation or its
   suppliers or licensors. Title to the Material remains with Intel Corporation
   or its suppliers and licensors. The Material contains trade secrets and
   proprietary and confidential information of Intel or its suppliers and
   licensors. The Material is protected by worldwide copyright and trade secret
   laws and treaty provisions. No part of the Material may be used, copied,
   reproduced, modified, published, uploaded, posted, transmitted, distributed,
   or disclosed in any way without Intels prior express written permission.

   No license under any patent, copyright, trade secret or other intellectual
   property right is granted to or conferred upon you by disclosure or delivery
   of the Materials, either expressly, by implication, inducement, estoppel or
   otherwise. Any license under such intellectual property rights must be express
   and approved by Intel in writing.
--*/
/*++

@file: mkhi_hdrs.h

--*/
#include <cse_basic_types.h>
#include "typedef.h"

#ifndef MKHI_HDRS_H_
#define MKHI_HDRS_H_

/**
*@page  page2  MKHI Specification
*@section abstract ABSTRACT

Intel platforms provide manageability features that allow IT departments to better manage corporate
assets as well as ensure the client systems independence on operating system being present.
These features are provided via manageability engine which runs out of band of host system and
therefore is able to execute and provide manageability even when host system is down.
ME accomplishes this task by participating in all system level activities such as power management
transitions, communication with host OS through selected drivers such as HECI driver etc. ME,
for the most part, operates independently of host, however in certain cases it does overlaps
with host; most notably in its requirement of h/w resources. For example, BIOS initializes memory
and informs ME such that it can utilize BIOS settings to initialize memory when needed.
Similarly before ME can provide client specific manageability, it needs to be configured.
One possible method to configure ME is MEBx, which runs during BIOS POST and communicates with ME over HECI messages.
Communication between ME and host is intricate and can be broadly divided in following categories:

<b> MKHI specification is divided into following sub-sections: </b> \n
*    \li \ref  groupid
*    \li \ref  group2
*    \li \ref  group6
*    \li \ref  bios-me
*    \li \ref  page4
*/

/** \defgroup group2 MKHI messages Generic Types and Structures
*@{
*BIOS interacts with Intel ME over Intel ME interface.The MEI(aka HCI)message header is the first dword of any MEI message.It is described with the following C prototype:
\li _CBM_HECI_MSG_HEADER. \n

* @}
*/

/** \defgroup group6  BIOS/MRC -ME Kernel Register Based HECI communication
* @{
Beginning with the Cougar Point chipset, the ME kernel and BIOS MRC will no longer use MKHI messages to communicate the DRAM INIT status.Instead the MRC will use HECI PCI CFG Space offset 0x4C to send the DRAM INIT message.The FW will then use Host HECI PCI CFG Space offset 0x40 to acknowledge the DRAM init message from BIOS as wells as the biosaction that FW requests of BIOS.Additionally, each processor may have its own requirements for placing ME UMA in the system memory map and these requirements may be found in the specific processors MRC BIOS Specification. \n
DRAM INIT request and reponse are defined below.
   \code
    DRAM INIT REQUEST
    Bits       Action
          31:28 0x01 = DRAM Init Done
          27:24 0x00 = Success
                  0x01 = No Memory in Channels
                  0x02 = Memory Init Error
                  0x03 = 0x0F = Reserved
          23:16 Reserved
          15:0  1M aligned ME UMA base address (maximum address bits supported - 36) This value
                  is to be read from MESEG_BASE[35:20]
          NOTE: 1M alignment is a new requirement for Cougar Point. The Intel 5 Series chipset
                is 64K alignment for ME UMA.
   \endcode

   \code
    DRAM INIT RESPONSE
    Bits       Action
            31:28   BIOS MSG ACK
                  0x01 = DRAM Init Done ACK
            27:25   ACK DATA (ME BIOS Action)
                  0x00 = No DID Ack received
                  0x01 = Non-power cycle reset
                  0x02 = Power cycle reset
                  0x03 = Go to S3
                  0x04 = Go to S4
                  0x05 = Go to S5
                  0x06 = Global reset
                  0x07 = Continue to boot
   \endcode
* @}
*/

/** \page  bios-me  BIOS-ME Kernel HECI Communication
This section covers the HECI messages that are exchanged between BIOS POST and ME firmware. Note that some of these messages might get used by the BIOS MRC however they are not restricted to MRC like messages. Related HECI messages are described below.
 * \li  \ref  resetblock
 * \li  \ref  mfgmrstblock
 * \li  \ref  eopblock
 * \li  \ref  memaddressblock
 *
 */

/** \page  page4  MEBx-ME Kernel HECI communication messages
This section covers HECI messages that are exchanged between MEBx and ME firmware (both kernel and application modules). Note that this section controls the MKHI version in that any changes in this section effectively increase the MKHI version.Upon starting, MEBx checks the MKHI and AMTHI version numbers and if compatible, runs on the platform. If MEBx is not compatible with either of these revisions then it displays an error message. This functionality allows MEBx to run from one platform to another a long as there have been no changes in MKHI or AMTHI version numbers.Related HECI messages are described below.
  *  \li \ref mkhiversion
  *  \li \ref fwversion
  *  \li \ref meunconfigure
  *  \li \ref merule
  *  \li \ref mepasswd
  *  \li \ref mefwsku
  *  \li \ref cpubrand
  *  \li \ref fwupdate
  *  \li \ref MdesMessages
  *  \li \ref MEBISTMessages
  *  \li \ref medbgMessages
  *
*/

/** \defgroup  resetblock    1.1 Resets
<b>Reset System</b> \n
In ME enabled system, ME is running in parallel to the host system. Any attempts to cause global reset without synchronizing the two
sides might cause unwanted side effects, such as unwritten flash data that will get destroyed if host were to cause a global reset without
informing ME and allowing ME to handle it first.  \n
\n
Therefore to maintain appropriate synchronization, following rules must be followed by host system: \n
1. If BIOS needs to do Global Reset and either of following is true then it must send the reset request HECI message instead of generating the global reset using CF9 based mechanisms:
             \verbatim
                 BIOS is in boot block and ME is in M3.
                 BIOS is in POST (has exited the boot block) and ME f/w status code is
                 initializing or initialized (does not reflect ERROR)
                 MEBx binary is requesting the global reset
              \endverbatim

2. If BIOS needs to do a host reset before memory initialization is complete then it must request ME firmware to perform the host reset using messages data structures and commands below. \n

<b>Reset Request</b>\n
This message is sent by the system BIOS, MEBx binary or host, when it needs to do a global reset in ME enabled system. Note that although this message does support requesting a host only reset, currently there are no known use cases where BIOS would be required to use this message to cause host only reset.
\verbatim
           Response Message Required:   In normal case, No. In case or error, yes
           NOTE: If this message is sent after END_OF_POST message, it is denied and an error
           response is sent
\endverbatim
*/


/** \defgroup  mfgmrstblock    1.2 Manufacturing ME reset and Halt  */
/** \defgroup  eopblock        1.3 END OF POST  */
/** \defgroup  memaddressblock 1.4 Set Debug Memory Address Request */



/** \defgroup  mkhiversion     2.1  Get MKHI  Version */
/** \defgroup  fwversion       2.2  Get FW    Version */
/** \defgroup  meunconfigure   2.3  ME  Unconfigure   */
/** \defgroup  merule          2.4  Get and Set ME Rule  */
/** \defgroup  mepasswd        2.5  Get and Set ME Password */
/** \defgroup  mefwsku         2.6  Get and set ME FW SKU and Capabilities */
/** \defgroup  cpubrand        2.7  CPU Brand Class Related messages */
/** \defgroup  fwupdate        2.8  FW Update Messages */
/** \defgroup  MdesMessages    2.9      ME MDES   Messages */
/** \defgroup  MEBISTMessages  2.10     ME BIST   Messages */
/** \defgroup  medbgMessages   2.12 ME Debug  Messages */

/** @addtogroup group2
 * The MKHI message header is defined here <b>_MKHI_MESSAGE_HEADER</b> and consists of the following elements.
 * \code
typedef union _MKHI_MESSAGE_HEADER
{
   // brief DWORD of MKHI header
   uint32_t     Data;
   struct
   {
      /// @brief GroupId of MKHI command specific to a client which will process the message.
      uint32_t  GroupId     :8;
      /// @brief command specific to HECI client.
      uint32_t  Command     :7;
      /// @brief resonnse from client which requires a client to respond.
      uint32_t  IsResponse  :1;
      /// @brief reserved bit field.
      uint32_t  Reserved    :8;
      /// @brief result
      uint32_t  Result      :8;
   }Fields;
}MKHI_MESSAGE_HEADER;

GroupId:8
Kernel Client specific information for dispatching. Refer to Table in MKHI messages Group ID for
possible values.

Command:7
Command code specific to MEI client.

IsResponse:
Set to 1 in response message.

Result:8
Result of the request message
\endcode
 *
 *
 */

//MKHI host message header. This header is part of HECI message sent from MEBx via
//Host Configuration Interface (HCI). ME Configuration Manager or Power Configuration
//Manager also include this header with appropriate fields set as part of the
//response message to the HCI.

typedef UINT32 uint32_t;

typedef union _mkhi_message_header_t
{
    UINT32      data;
    struct
    {
        UINT32  group_id    :8;   /// the target client id registered to process the message
        UINT32  command     :7;   /// command specific to HECI client
        UINT32  is_response :1;   /// response from client
        UINT32  reserved    :8;   /// reserved bit field
        UINT32  result      :8;   /// result
    } fields;
} mkhi_message_header_t;
C_ASSERT(sizeof(mkhi_message_header_t) == 4);

#if 1 // Legacy ME typedef
typedef union _MKHI_MESSAGE_HEADER
{
    UINT32     Data;
    struct
    {
        /// @brief Group Id of MKHI command specific to a client which will process the message.
        UINT32  GroupId     :8;
        /// @brief command specific to HECI client.
        UINT32  Command     :7;
        /// @brief resonnse from client which requires a client to respond.
        uint32_t  IsResponse  :1;
        /// @brief reserved bit field.
        uint32_t  Reserved    :8;
        /// @brief result
        uint32_t  Result      :8;
    }Fields;
}MKHI_MESSAGE_HEADER;
C_ASSERT(sizeof(MKHI_MESSAGE_HEADER) == 4);
#endif

// Typedef for GroupID
/** \page  groupid  MKHI messages Group ID
*Each MKHI client in firmware is identified by its GROUP ID. Following GROUPIDs are supported in firmware:
*<table border = "3">
<tr>
<td><center><b> Group ID </b></center></td>
<td><center><b>Category Details</b></center></td>
</tr>
<tr>
<td>MKHI_CBM_GROUP_ID=0x00</td>
<td>Core BIOS Messages targeted for PM driver</td>
</tr>
<tr>
<td>MKHI_PM_GROUP_ID=0x01</td>
<td>PM Config Messages</td>
</tr>
<tr>
<td>MKHI_PWD_GROUP_ID=0x02</td>
<td>Password config messages</td>
</tr>
<tr>
<td>MKHI_FWCAPS_GROUP_ID=0x03</td>
<td>FW Capabilities config messages</td>
</tr>
<tr>
<td>MKHI_APP_GROUP_ID=0x04</td>
<td>Application config data access messages</td>
</tr>
<tr>
<td>MKHI_FWUPDATE_GROUP_ID=0x05</td>
<td>Used to Query and resume FW update process. This is used for manufacturing downgrade.</td>
</tr>
<tr>
<td>MKHI_FIRMWARE_UPDATE_GROUP_ID=0x06</td>
<td>Used for FW upgrade process. Need to check with FWU team..</td>
</tr>
<tr>
<td>MKHI_BIST_GROUP_ID=0x07</td>
<td>Used for perform ME BIST tests.</td>
</tr>
<tr>
<td>MKHI_MDES_GROUP_ID=0x08</td>
<td>Used for ME debug MDES messaging </td>
</tr>
<tr>
<td>MKHI_ME_DBG_GROUP_ID=0x09</td>
<td>Used internally for ME debug.</td>
</tr>
<tr>
<td>MKHI_FPF_GROUP_ID=0x10</td>
<td> Maximum value of MKHI group ID</td>
</tr>
<tr>
<td>MKHI_MAX_GROUP_ID=0x11</td>
<td> Maximum value of MKHI group ID</td>
</tr>
<tr>
<td>MKHI_GEN_GROUP_ID =0xff</td>
<td>General messages targeted to MKHI fw client</td>
</tr>
*</table>
*/

typedef enum
{
    MKHI_GROUP_ID_CBM                   = 0x00, //policy
    //MKHI_GROUP_ID_PM                    = 0x01, //Reserved
    MKHI_GROUP_ID_PWD                   = 0x02, //policy
    MKHI_GROUP_ID_FWCAPS                = 0x03, //policy
    //MKHI_GROUP_ID_APP                   = 0x04, //Reserved
    MKHI_GROUP_ID_FWUPDATE              = 0x05, //FWU (HMRPFO)
    //MKHI_GROUP_ID_FIRMWARE_UPDATE       = 0x06, //FWU
    MKHI_GROUP_ID_BIST                  = 0x07, //policy
    //MKHI_GROUP_ID_MDES                  = 0x08, //Reserved
    MKHI_GROUP_ID_ME_DBG                = 0x09, //Reserved
    MKHI_GROUP_ID_MCA                   = 0x0A, //MCA
#ifdef CSE_CONF_DNX_ENABLE
    MKHI_GROUP_ID_DNX                   = 0x0D, //policy
#endif
#if CSE_SPS_CONF_ENABLE
    MKHI_GROUP_ID_NM                    = 0x11, //NM
    MKHI_GROUP_ID_PTU                   = 0x14, //PTU
#endif // CSE_SPS_CONF_ENABLE
    MKHI_GROUP_ID_SECURE_BOOT           = 0x0C, //Secure Boot - small core   
    MKHI_GROUP_ID_IFWI                  = 0x20, //IFWI update - small core
    MKHI_GROUP_ID_BUP_COMMON            = 0xF0, //policy-bup
    MKHI_GROUP_ID_BUP_ICC               = 0xF1, //icc-bup
    MKHI_GROUP_ID_BUP_MPHY              = 0xF2, //icc-bup
    MKHI_GROUP_ID_BUP_PM                = 0xF3, //policy- bup
    MKHI_GROUP_ID_GEN                   = 0xFF  //policy
} mkhi_group_id_t;

#endif /* MKHI_HDRS_H_ */
